@extends('admin.master')
@section('content')
    <!-- Custom styles for this page -->
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <!-- DataTales Example -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Celebrity Order Information</h6>
                </div>

                <div class="form-row mt-3">
                    <div class="col-md-4">
                        <div class="form-group">
                            <select class="form-control ml-4 celebrity" name="celebrity">
                                <option value="">-All Celebrity-</option>
                                @foreach($celebrities as $row)
                                    <option value="{{ $row->CELEBRITY_ID }}">{{ $row->MEMBERS_NAME }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <select class="form-control ml-4 orderType" name="orderType">
                                <option value="">-All Type-</option>
                                <option value="delivered">Delivered</option>
                                <option value="accepted">Accepted</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group ml-4">
                            <button type="submit" class="btn btn-primary searchOrders">Search</button>
                        </div>
                    </div>
                </div>


                <div class="card-body ">
                    <div class="table-responsive">
                        <table class="table table-bordered celebrity-order" id="dataTable" width="100%" cellspacing="0">
                            <thead>
                            <tr>
                                <th>Sl.</th>
                                <th>Customer Name</th>
                                <th>Media</th>
                                <th>Contact</th>
                                <th>Delivery Date</th>
                                <th>Delivery Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tfoot>
                            <tr>
                                <th>Sl.</th>
                                <th>Customer Name</th>
                                <th>Media</th>
                                <th>Contact</th>
                                <th>Delivery Date</th>
                                <th>Delivery Status</th>
                                <th>Action</th>
                            </tr>
                            </tfoot>
                            <tbody>
                                @foreach($orders as $key => $order)
                                <tr>
                                    <td>{{ ++$key }}</td>
                                    <td>{{ $order->USERNAME }}</td>
                                    <td>Facebook</td>
                                    <td>{{ $order->CONTACT_NO }} </td>
                                    <td>{{ date('d-M-Y', strtotime($order->DELIVERY_DATE)) }}</td>
                                    <td><button class="btn btn-primary btn-sm">Pending</button></td>
                                    <td>
                                        <a href="#" class="btn btn-success btn-circle btn-sm" id="modalOpen" data-action="{{ url('orders-process/'.$order->ORDERMST_ID) }}" data-modal="modal-xl" data-title="View Order Details"  data-toggle="modal" data-target="#openModal"><i class="fas fa-eye"></i></a>
                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- ol-lg-12 col-md-12-->
    </div> <!-- /.row-->
    <script>
        $(document).on('click', '.searchOrders', function () {
            var celebrityId = $('.celebrity').val();
            var orderTypeId = $('.orderType').val();
            var url = '{{ url('search-celebrity-orders') }}';
            var token = '{{ csrf_token() }}';

            $.ajax({
                type:'POST',
                dataType:'HTML',
                url:url,
                data:{
                    url: url,
                    _token: token,
                    celebrityId: celebrityId,
                    orderTypeId: orderTypeId
                },
                success:function (data) {
                    $('.celebrity-order').html(data);
                }
            });

        })
    </script>
@endsection


