@extends('admin.master')
@section('content')
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Registered Members</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>Sl.</th>
                                    <th>Name</th>
                                    <th>Country</th>
                                    <th>District</th>
                                    <th>Address</th>
                                    <th>Contact</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tfoot>
                                <tr>
                                    <th>Sl.</th>
                                    <th>Name</th>
                                    <th>Country</th>
                                    <th>District</th>
                                    <th>Address</th>
                                    <th>Contact</th>
                                    <th>Action</th>
                                </tr>
                            </tfoot>

                            <tbody>
                            @foreach($members as $key => $row)
                                <tr>
                                    <td>{{ ++$key }}</td>
                                    <td>{{ $row->MEMBERS_NAME }}</td>
                                    <td>{{ $row->country_name }}</td>
                                    <td>{{ $row->district_name }}</td>
                                    <td>{{ $row->ADDRESS }}</td>
                                    <td>{{ $row->MOBILE_NO }}</td>
                                    <td>
                                        <a href="#" class="btn btn-success btn-circle btn-sm" id="modalOpen" data-action="{{ url('celebrities-registration/'.$row->CELEBRITY_ID) }}" data-modal="modal-xl" data-title="Celebrity Profile Details"  data-toggle="modal" data-target="#openModal"><i class="fas fa-eye"></i></a>
                                        <a href="#" class="btn btn-info btn-circle btn-sm" id="modalOpen" data-action="{{ url('celebrities-registration/'.$row->CELEBRITY_ID.'/edit') }}" data-modal="modal-lg" data-title="Edit Celebrity Information"  data-toggle="modal" data-target="#openModal"><i class="fas fa-edit"></i></a>
                                        <a href="#" class="btn btn-danger btn-circle btn-sm clickForDelete row{{ $row->CELEBRITY_ID }}" data-token="{{ csrf_token() }}" data-action="{{ url('celebrities-registration/'.$row->CELEBRITY_ID) }}" role="button"><i class="fas fa-trash"></i></a>

                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- ol-lg-12 col-md-12-->

    </div> <!-- /.row-->

    @include('admin.includes.deleteScript')

@endsection


