@extends('admin.master')
@section('content')
    <!-- Custom styles for this page -->
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <!-- DataTales Example -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Customers</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                            <thead>
                            <tr>
                                <th>Sl.</th>
                                <th>Username</th>
                                <th>Contact</th>
                                <th>Email</th>
                                <th>Address</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tfoot>
                            <tr>
                                <th>Sl.</th>
                                <th>Username</th>
                                <th>Contact</th>
                                <th>Email</th>
                                <th>Address</th>
                                <th>Action</th>
                            </tr>
                            </tfoot>
                            <tbody>
                            @foreach($customers as $key => $customer)
                                <tr>
                                    <td>{{ ++$key }}</td>
                                    <td>{{ $customer->USERNAME }}</td>
                                    <td>{{ $customer->CONTACT }} </td>
                                    <td>{{ $customer->EMAIL }} </td>
                                    <td>{{ $customer->ADDRESS }} </td>
                                    <td>
                                        <a href="#" class="btn btn-info btn-circle btn-sm" id="modalOpen" data-action="{{ url('admin-customers/'.$customer->CUSTOMER_ID.'/edit') }}" data-modal="modal-lg" data-title="Edit {{ $customer->USERNAME }}"  data-toggle="modal" data-target="#openModal"><i class="fas fa-edit"></i></a>
                                        <a href="#" class="btn btn-danger btn-circle btn-sm clickForDelete row{{ $customer->CUSTOMER_ID }}" data-token="{{ csrf_token() }}" data-action="{{ url('admin-customers/'.$customer->CUSTOMER_ID) }}" role="button"><i class="fas fa-trash"></i></a>

                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- ol-lg-12 col-md-12-->
    </div> <!-- /.row-->
    @include('admin.includes.deleteScript')

@endsection


