@extends('admin.master')
@section('content')
    <!-- Custom styles for this page -->
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <!-- DataTales Example -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Goods Received</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                            <thead>
                            <tr>
                                <th>Sl.</th>
                                <th>Product Name</th>
                                <th>Packet Type</th>
                                <th>Is Box</th>
                                <th>Qty.</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tfoot>
                            <tr>
                                <th>Sl.</th>
                                <th>Product Name</th>
                                <th>Packet Type</th>
                                <th>Is Box</th>
                                <th>Qty.</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </tfoot>
                            <tbody>
                            @foreach($goods as $key => $row)
                                <tr>
                                    <td>{{ ++$key }}</td>
                                    <td>{{ $row->PROD_NAME }}</td>
                                    <td>{{ $row->LDATA_NAME }} </td>
                                    <td><input type="checkbox" @if($row->IS_BOX===1) checked @endif></td>
                                    <td>{{ $row->QUANTITY }} </td>
                                    <td>
                                        @if($row->ACTIVE_FLG==1)
                                            <button class="btn btn-primary btn-sm">Verified</button>
                                        @else
                                            <button class="btn btn-danger btn-sm verifyGoods" value="{{ $row->GOODS_RCV_ID }}">Pending</button>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="#" class="btn btn-info btn-circle btn-sm" id="modalOpen" data-action="{{ url('goods-receive/'.$row->GOODS_RCV_ID.'/edit') }}" data-modal="modal-lg" data-title="Edit Product Receive"  data-toggle="modal" data-target="#openModal"><i class="fas fa-edit"></i></a>
                                        <a href="#" class="btn btn-danger btn-circle btn-sm clickForDelete row{{ $row->GOODS_RCV_ID }}" data-token="{{ csrf_token() }}" data-action="{{ url('goods-receive/'.$row->GOODS_RCV_ID) }}" role="button"><i class="fas fa-trash"></i></a>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- ol-lg-12 col-md-12-->
    </div> <!-- /.row-->
    @include('admin.includes.deleteScript')

    <script>
        $(document).on("click", ".verifyGoods", function (e) {
            e.preventDefault();
            var thisRow = $(this).closest('tr');
            var goodsId = thisRow.find('.verifyGoods').val();
            var actionUrl = "{{ url('verify-goods') }}";
            var token = "{{ csrf_token() }}";

            swal.fire({
                title:'Are you sure ?',
                type:'warning',
                text: 'Please click confirm to Verify',
                showCancelButton:true,
                confirmButtonText:'Yes, Confirm',
                cancelButtonText:'No, cancel',
                confirmButtonColor:'#3085d6',
                cancelButtonColor:'#d33',
                confirmButtonClass: 'btn-danger',
                cancelButtonClass:'btn-primary',
                buttonsStyling:true,
            }).then(function (isConfirm) {
            if (isConfirm.value){
                $.ajax({
                    type: 'POST',
                    data: {
                       _token: token, goodsId: goodsId
                    },
                    url: actionUrl,
                    success:function (data) {
                        location.reload();
                    }

                });
            }else{
                swal.fire(
                    'Canceled',
                    'Sorry! we could not verify',
                    'error'
                )
            }

            })
        })

    </script>

@endsection


