@extends('admin.master')
@section('content')
    <!-- Custom styles for this page -->
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <!-- DataTales Example -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Orders Delivered</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                            <thead>
                            <tr>
                                <th>Sl.</th>
                                <th>Order No</th>
                                <th>Customer Name</th>
                                <th>Contact</th>
                                <th>Delivery Date</th>
                                <th>Payment Type</th>
                                <th>Total Amount</th>
                                <th>Delivery Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tfoot>
                            <tr>
                                <th>Sl.</th>
                                <th>Order No</th>
                                <th>Customer Name</th>
                                <th>Contact</th>
                                <th>Delivery Date</th>
                                <th>Payment Type</th>
                                <th>Total Amount</th>
                                <th>Delivery Status</th>
                                <th>Action</th>
                            </tr>
                            </tfoot>
                            <tbody>
                                @foreach($ordersDeliver as $key => $order)
                                <tr>
                                    <td>{{ ++$key }}</td>
                                    <td>{{ $order->ORDERMST_ID }}</td>
                                    <td>{{ $order->USERNAME }}</td>
                                    <td>{{ $order->CONTACT_NO }} </td>
                                    <td style="width: 14%">{{ date('d-M-Y', strtotime($order->DELIVERY_DATE)) }}</td>
                                    <td style="width: 15%"><button class="btn btn-primary btn-sm">{{ $order->paymentType }}</button></td>
                                    <td>${{ number_format($order->totalAmount, 2) }} </td>
                                    <td><button class="btn btn-primary btn-sm">Pending</button></td>
                                    <td>
                                        <a href="#" class="btn btn-success btn-circle btn-sm" id="modalOpen" data-action="{{ url('orders-deliver/'.$order->ORDERMST_ID) }}" data-modal="modal-xl" data-title="View Order Delivery Details"  data-toggle="modal" data-target="#openModal"><i class="fas fa-eye"></i></a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- ol-lg-12 col-md-12-->
    </div> <!-- /.row-->

@endsection


