@extends('admin.master')
@section('content')
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Products Policy</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                            <thead>
                            <tr>
                                <th>Sl.</th>
                                <th>Product Name</th>
                                <th>Packet Type</th>
                                <th>Discount(%)</th>
                                <th>Free Qty.</th>
                                <th>Point</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tfoot>
                            <tr>
                                <th>Sl.</th>
                                <th>Product Name</th>
                                <th>Packet Type</th>
                                <th>Discount(%)</th>
                                <th>Free Qty.</th>
                                <th>Point</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </tfoot>

                            <tbody>
                            @foreach($policies as $key => $row)
                                <tr>
                                    <td>{{ ++$key }}</td>
                                    <td>{{ $row->PROD_NAME }}</td>
                                    <td>{{ $row->LDATA_NAME }}</td>
                                    <td>{{ $row->DISC_PCT }}</td>
                                    <td>{{ $row->FREE_QTY }}</td>
                                    <td>{{ $row->POINT }}</td>
                                    <td>
                                        @if($row->ACTIVE_FLG==1)
                                            <button class="btn btn-primary btn-sm">Active</button>
                                        @else
                                            <button class="btn btn-danger btn-sm">Inactive</button>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="#" class="btn btn-info btn-circle btn-sm" id="modalOpen" data-action="{{ url('product-policies/'.$row->POLICY_ID.'/edit') }}" data-modal="modal-lg" data-title="Edit Product Policy"  data-toggle="modal" data-target="#openModal"><i class="fas fa-edit"></i></a>
                                        <a href="#" class="btn btn-danger btn-circle btn-sm clickForDelete row{{ $row->POLICY_ID }}" data-token="{{ csrf_token() }}" data-action="{{ url('product-policies/'.$row->POLICY_ID) }}" role="button"><i class="fas fa-trash"></i></a>

                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- ol-lg-12 col-md-12-->

    </div> <!-- /.row-->

    @include('admin.includes.deleteScript')
@endsection


