@extends('admin.master')
<style>
    td{
        text-align: center !important;
        vertical-align: middle !important;
    }
</style>

@section('content')
    <!-- Custom styles for this page -->
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <!-- DataTales Example -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Processed Orders Print</h6>
                </div>
                <div class="card-body">
                    <!-- carry via -->
                    <div class="form-row mt-3">
                        <div class="col-md-2">
                            <div class="form-group">
                                <b>Choose Carrier</b>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <select class="form-control carrier_id" required>
                                    <option value=""> Select Carrier</option>
                                    @foreach($organizations as $row)
                                        <option value="{{ $row->ORGANIZATION_ID }}">{{ $row->ORGANIZATION_NAME }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <input type="text" class="form-control fromDate date-picker" name="fromDate" value="{{ date('d-M-Y', strtotime(date('d-M-Y'). '-2 days')) }}">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <input type="text" class="form-control toDate date-picker" name="toDate" value="{{ date('d-M-Y') }}">
                            </div>
                        </div>
                        <div class="col-md-1">
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary searchOrders">Search</button>
                            </div>
                        </div>
                    </div>

                    <!-- process order list for carry  -->
                    <div class="printOrders">
                        @include('admin.layouts.reportsPrint.processedOrders.orders')
                    </div>
                    {{--<!-- process order list for carry  -->--}}

                </div> <!--/. card body -->

            </div> <!--card -->
        </div> <!-- ol-lg-12 col-md-12-->
    </div> <!-- /.row-->
    <script>
        $('#datepicker').datepicker({
            uiLibrary: 'bootstrap4'
        });
       // search orders to deliver
        $(document).on('click', '.searchOrders', function () {
            var carrierId = $('.carrier_id').val();
            var fromDate = $('.fromDate').val();
            var toDate = $('.toDate').val();

            var url = '{{ url('search-delivery-orders') }}';
            var token = '{{ csrf_token() }}';

            if (carrierId==''){
                alert('Please Select Carrier');
            }else{
                $.ajax({
                    type:'POST',
                    dataType:'HTML',
                    url:url,
                    data:{
                        url: url,
                        _token: token,
                        carrierId: carrierId,
                        fromDate: fromDate,
                        toDate: toDate,
                    },
                    success:function (data) {
                        $('.printOrders').html(data);
                    }
                });
            }

        });


    </script>
@endsection


