
<div class="table-responsive">
    <h4 class="text-center card-header">Orders to be delivered</h4>
    <table class="table table-bordered" width="100%" cellspacing="0">
        <thead>
        <tr>
            <th>Order</th>
            <th>Customer</th>
            <th>Product</th>
            <th>Photo</th>
            <th>Qty.</th>
            <th>Total</th>
            <th>Price</th>
            <th>Total</th>
            <th>Address</th>
            <th>Payment Type</th>
        </tr>
        </thead>
        <tfoot>
        <tr>
            <th>Order</th>
            <th>Customer</th>
            <th>Product</th>
            <th>Photo</th>
            <th>Qty.</th>
            <th>Total</th>
            <th>Price</th>
            <th>Total</th>
            <th>Address</th>
            <th>Payment Type</th>
        </tr>
        </tfoot>
        <tbody>
        @foreach($ordersToDeliver as $key => $row)
            @php
                $childOrders = \Illuminate\Support\Facades\DB::table('sf_orderchd')
                                ->select('sf_orderchd.ORDERMST_ID','sf_orderchd.QUANTITY','sf_orderchd.PRICE','sf_product_info.PROD_NAME','sf_product_info.PRODUCT_IMG')
                                ->leftjoin('sf_product_info','sf_orderchd.PRODUCT_ID','=','sf_product_info.PRODUCT_ID')
                                ->where('sf_orderchd.ORDERMST_ID','=',$row->ORDERMST_ID)
                                ->get();
                $count = \Illuminate\Support\Facades\DB::table('sf_orderchd')
                                ->select(DB::raw('COUNT(ORDERMST_ID) AS rowSpan'), DB::raw('SUM(QUANTITY) AS totalQty') , DB::raw('SUM(PRICE) AS totalAmount'))
                                ->where('ORDERMST_ID','=',$row->ORDERMST_ID)
                                ->first();
            @endphp
            @foreach($childOrders as $key2 => $child)
                <tr>
                    @if($key2==0)
                        <td rowspan="{{ $count->rowSpan }}">#{{ $child->ORDERMST_ID }}</td> <!-- order no -->
                        <td rowspan="{{ $count->rowSpan }}">{{ $row->USERNAME }}</td>
                    @endif

                    <td>{{ $child->PROD_NAME }}</td>
                    <td><img src="{{ asset('/uploads/products/'.$child->PRODUCT_IMG) }}" alt="Product Image" style="width: 40px;height: 40px;border: 1px solid lightgray;padding: 2px;"></td>
                    <td>{{ $child->QUANTITY }}</td>

                    @if($key2==0)
                        <td rowspan="{{ $count->rowSpan }}">{{ $count->totalQty }}</td>
                    @endif

                    <td>{{ number_format($child->PRICE, 2) }}</td>

                    @if($key2==0)
                        <td rowspan="{{ $count->rowSpan }}">{{ number_format($count->totalAmount, 2) }}</td>
                    @endif

                    @if($key2==0)
                        <td rowspan="{{ $count->rowSpan }}" style="width: 20%;">{{ $row->ORDER_PLACE }}</td>
                    @endif

                    @if($key2==0)
                        <td rowspan="{{ $count->rowSpan }}">{{ $row->paymentType }}</td>
                    @endif
                </tr>
            @endforeach
        @endforeach
        </tbody>
    </table>
</div>