<style>
    h4{
        text-align: center;
        font-size: 25px;
    }
    table {
        border-collapse: collapse;
    }

    table, td, th {
        border: 1px solid black;
    }
    td, th {
        padding-left: 5px;
    }
</style>

<div class="table-responsive">
    <h4 class="text-center"><u>Orders to be delivered</u> </h4>
    <table class="table table-bordered" width="100%" cellspacing="1" border="0" cellpadding="2">
        <thead>
        <tr>
            <th>Order</th>
            <th>Customer</th>
            <th>Product</th>
            <th>Photo</th>
            <th>Qty.</th>
            <th>Total</th>
            <th>Price</th>
            <th>Total</th>
            <th>Address</th>
            <th>Payment Type</th>
        </tr>
        </thead>
        <tbody>

        @foreach($ordersToDeliver as $key => $row)
            @php
                $childOrders = \Illuminate\Support\Facades\DB::table('sf_orderchd')
                                ->select('sf_orderchd.ORDERMST_ID','sf_orderchd.QUANTITY','sf_orderchd.PRICE','sf_product_info.PROD_NAME','sf_product_info.PRODUCT_IMG')
                                ->leftjoin('sf_product_info','sf_orderchd.PRODUCT_ID','=','sf_product_info.PRODUCT_ID')
                                ->where('sf_orderchd.ORDERMST_ID','=',$row->ORDERMST_ID)
                                ->get();
                $count = \Illuminate\Support\Facades\DB::table('sf_orderchd')
                                ->select(DB::raw('COUNT(ORDERMST_ID) AS rowSpan'), DB::raw('SUM(QUANTITY) AS totalQty') , DB::raw('SUM(PRICE) AS totalAmount'))
                                ->where('ORDERMST_ID','=',$row->ORDERMST_ID)
                                ->first();

            @endphp
            @foreach($childOrders as $key2 => $child)
                <tr>
                    @if($key2==0)
                        <td rowspan="{{ $count->rowSpan }}"  >#{{ $child->ORDERMST_ID }}</td> <!-- order no -->
                        <td rowspan="{{ $count->rowSpan }}" >{{ $row->USERNAME }}</td>
                    @endif

                    <td>{{ $child->PROD_NAME }}</td>
                    <td>
                        <img src="{{ base_path().'/public/uploads/products/'.$child->PRODUCT_IMG  }}" alt="Logo" width="30px;" height="40">
                    </td>
                    <td>{{ $child->QUANTITY }}</td>

                    @if($key2==0)
                        <td rowspan="{{ $count->rowSpan }}" >{{ $count->totalQty }}</td>
                    @endif

                    <td>${{ number_format($child->PRICE, 2) }}</td>

                    @if($key2==0)
                        <td rowspan="{{ $count->rowSpan }}" >${{ number_format($count->totalAmount, 2) }}</td>
                    @endif

                    @if($key2==0)
                        <td rowspan="{{ $count->rowSpan }}" style="width: 20%;">{{ $row->ORDER_PLACE }}</td>
                    @endif

                    @if($key2==0)
                        <td rowspan="{{ $count->rowSpan }}">{{ $row->paymentType }}</td>
                    @endif
                </tr>
            @endforeach
        @endforeach
        </tbody>
    </table>
</div>
