@extends('admin.master')
@section('content')
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Item Stocks</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                            <thead>
                            <tr>
                                <th>Sl.</th>
                                <th>Product Name</th>
                                <th>Packet Type</th>
                                <th>Box</th>
                                <th>Stock In</th>
                                <th>Stock Out</th>
                                <th>Current Stock</th>
                            </tr>
                            </thead>
                            <tfoot>
                            <tr>
                                <th>Sl.</th>
                                <th>Product Name</th>
                                <th>Packet Type</th>
                                <th>Box</th>
                                <th>Stock In</th>
                                <th>Stock Out</th>
                                <th>Current Stock</th>
                            </tr>
                            </tfoot>

                            <tbody>
                            @foreach($stocks as $key => $row)
                                <tr>
                                    <td>{{ ++$key }}</td>
                                    <td>{{ $row->PROD_NAME }}</td>
                                    <td>{{ $row->packetType }}</td>
                                    <td><input type="checkbox" name="is_box" @if($row->IS_BOX==1) checked @endif disabled ></td>
                                    <td>{{ $row->stock_in }}</td>
                                    <td>{{ $row->stock_out }}</td>
                                    <td>{{ $row->stock_in-$row->stock_out }}</td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- ol-lg-12 col-md-12-->

    </div> <!-- /.row-->

@endsection


