<script>
//    ***************** Cart Script Start *****************
    $(document).on('click', '.add-cart', function (e) {
        e.preventDefault();
        let product_id = $(this).attr('data-id');
        let product_quantity = $(this).attr('data-quantity');
        let data_pack_id = $(this).attr('data-pack-id');
        let isOrderBox = $(this).attr('data-is-sell-box');
        let product_price = $(this).attr('data-price');
        let token = '{{ csrf_token() }}';
        let route = "{{ url('/') }}";

        $.ajax({
            url: `${route}/carts`,
            type: "POST",
            data: {product_id : product_id, product_quantity : product_quantity, data_pack_id: data_pack_id, isOrderBox: isOrderBox, product_price : product_price, _token : token},
            dataType: 'HTML',
            success: function (data) {
                // console.log(data);
                getUpdateCart();
                $('.cart-notification').notify("Cart Updated", 'Success');
            }
        });
    });

//    Product Remove From Cart
    $(document).on('click', '.product-remove', function (e) {
        e.preventDefault();
        let thisRow = $(this).closest('.products-counter');
        let product_id = $(this).attr('data-id');
        let token = '{{ csrf_token() }}';
        let route = "{{ url('/') }}";

        $.ajax({
            url: `${route}/carts/${product_id}`,
            type: "DELETE",
            data: {product_id : product_id, _token : token},
            success: function (data) {
//                console.log(data);
                thisRow.remove();
                getUpdateCart();
                $('.cart-notification').notify("Cart Updated", 'Success');
            }
        });
    });

//    Cart View On Ready
    $(document).ready(function () {
        getUpdateCart();
    });

//    Check Empty Card Detail
    const checkEmptyCart = () => {
        let number = 0;
        $('.products-counter').each(function () {
            number++;
        });
        if(number>0) $('.orderSubmit').prop('disabled', false);
    };

//    Get Update Cart Product
    const getUpdateCart = () => {
        $.ajax({
            url: "{{ url('/carts') }}",
            type: "GET",
            dataType: 'HTML',
            success: function (cart) {
                $('.shopping__cart').html(cart);
                $('.htc__qua').text(totalProductInCart(cart));
            }
        });
    };
//    Count Product in Cart
    const totalProductInCart = (cart) => {
        var count = 0;
        $(cart).find('.products-counter').each(function () {
            count++;
        });
        return count;
    };

//    ***************** Cart Script End *****************

//    ***************** Validation Script End *****************
    const hasError = () => {
        let error = false;
        $('.required').each(function () {
            let inputValue = $(this).val();
            if(inputValue===''){
                $(this).notify('This Field is Required', 'error');
                error = true;
                return false;
            }
        });
        return error;
    }
//    ***************** Validation Script End *****************

</script>