<style>
    .new_arrival_img{
        border: 1px solid lightgray;
        padding-top: 10px;
    }
    .category {
        margin-top: 0;
    }
    .fr__product__inner {
        padding: 15px 0 15px 0;
        text-align: center;
    }
    .single-product{
        margin-bottom: 40px;
    }
</style>
<section class="htc__category__area ptb--20" id="new_arrivals">
    <div class="container">
        <div class="row">
            <div class="col-xs-12">
                <div class="section__title--2 text-center">
                    <h2 class="title__line">New Arrivals</h2>
                </div>
            </div>
        </div>
        <div class="htc__product__container">
            <div class="row">
                <div class="product__list clearfix mt--30">
                    <!-- Start Single Category -->
                    @foreach($products as $product)
                        @php
                            $sellPrice = $product->IS_SELL_BOX==1 ? $product->BOX_PRICE : $product->UNIT_PRICE;
                            $price = $sellPrice-(($product->DISC_PCT*$sellPrice)/100);
                            $unitDiscount = $product->UNIT_PRICE-(($product->DISC_PCT*$product->UNIT_PRICE)/100);
                            $boxDiscount = $product->BOX_PRICE-(($product->DISC_PCT*$product->BOX_PRICE)/100);

                        @endphp
                        <div class="col-md-4 col-lg-3 col-sm-4 col-xs-12 single-product">
                            <div class="category new_arrival_img">
                                <div class="ht__cat__thumb">
                                    <a href="{{ url('product-details/'.$product->PRODUCT_ID) }}">
                                        <img src="{{ asset('public/uploads/products/'.$product->PRODUCT_IMG) }}" alt="product images" class="img-responsive single-product-image img-rounded" >
                                    </a>
                                </div>
                                <div class="fr__hover__info">
                                    <ul class="product__action">
                                        <li>
                                            <a href="#"><i class="icon-heart icons"></i></a>
                                        </li>
                                        {{--<i class="icon-handbag icons"></i>--}}
                                        @if(Session::get('username'))
                                            <li><a href="#" class="add-cart" data-id="{{ $product->PRODUCT_ID }}" data-quantity="1" data-pack-id="{{ $product->PACK_TYPE_ID }}" data-is-sell-box="{{ $product->IS_SELL_BOX }}" data-price="{{ $price }}"><i class="fa fa-cart-plus" title="Add to cart"></i></a></li>
                                        @else
                                            <li><a href="#" class="add-cart" data-toggle="modal" data-target="#modalLoginRegister"><i class="fa fa-cart-plus" title="Add to cart"></i></a></li>
                                        @endif

                                        <li>
                                            <a href="#"><i class="icon-shuffle icons"></i></a>
                                        </li>
                                    </ul>
                                </div>
                                <div class="fr__product__inner">
                                    <h4><a href="{{ url('product-details/'.$product->PRODUCT_ID) }}">{{ $product->PROD_NAME }}</a></h4>
                                    <ul class="fr__pro__prize price-customize">
                                        @if($product->DISC_PCT==0)
                                            <li>{{ $product->TYPE_NAME }}: <span>${{ $product->UNIT_PRICE }}</span></li>
                                            <li>Box: <span>${{ $product->BOX_PRICE }}</span> </li>
                                        @else
                                            <li>{{ $product->TYPE_NAME }}: <span>${{ $unitDiscount }}</span> <del> ${{ $product->UNIT_PRICE }}</del></li>
                                            <li>Box: <span>${{ $boxDiscount }}</span> <del> ${{ $product->BOX_PRICE }}</del> </li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                        </div>
                    @endforeach
                    <!-- End Single Category -->

                </div>
            </div>
        </div>
    </div>
</section>