@extends('public.master')
<style>
    .cart-img{
        width: 70px;
        height: 90px;
    }
    .table-content table th, .table-content table td {
        padding: 7px!important;
    }
    .table-content table td.product-trash i {
        color: #212121;
        display: inline-block;
        font-size: 24px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        width: 40px;
    }
    #scrollUp {
        padding-top: 8px;
    }
    .table-content table td.product-trash i:hover {
        color: red;
    }
    .payment-style{
        padding: 5px;
        border: 1px solid #f2f2f2;
        min-height: 275px !important;
    }
    .payment-f6{
        padding: 4px !important;
        margin-bottom: 5px;
    }
    .shipping-form{
        padding: 10px !important;
        border: 1px solid #f2f2f2;
        min-height: 255px;
    }
    .form-group label{
        color: black;
        font-family: 'Poppins', sans-serif;
        font-size: 14px;
        font-weight: inherit;
        text-transform: uppercase;
    }
</style>
@section('content')
    <!-- cart-main-area start -->
    <div class="cart-main-area ptb--100 bg__white">
        <div class="container">
            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="table-content table-responsive">
                        <table>
                            <thead>
                            <tr>
                                <th class="product-thumbnail">Product(s)</th>
                                <th class="product-name">Name of product(s)</th>
                                <th class="product-name">Pack Type</th>
                                <th class="product-name">Regular Price</th>
                                <th class="product-name">Discount (%)</th>
                                <th class="product-price">Price</th>
                                <th class="product-quantity" style="width: 350px">Quantity</th>
                                <th class="product-subtotal">Total</th>
                                <th class="product-remove" style="width: 10%;">Remove</th>
                            </tr>
                            </thead>
                            <tbody>
                            @php
                                $totalPrice = 0;
                                $cartTotal = 0;
                            @endphp
                            @foreach($carts as $cart)
                                @php
                                    $sellPrice = $cart->IS_BOX_ORDER==1 ? $cart->BOX_PRICE : $cart->UNIT_PRICE;
                                    $unitPrice = $sellPrice-(($cart->DISC_PCT*$sellPrice)/100);
                                    $totalPrice = $cart->QUANTITY * $unitPrice;
                                    $cartTotal = $totalPrice + $cartTotal;
                                @endphp
                                <tr class="products-counter">
                                    <td class="product-thumbnail">
                                        <a href="#"><img src="{{ asset('public/uploads/products/'.$cart->PRODUCT_IMG) }}" class="img-responsive cart-img center-block" alt="product img" style="height: 80px;border: 1px solid lightblue;padding: 5px;" /></a></td>
                                    <td class="product-name"><a href="#">{{ $cart->PROD_NAME }}</a></td>
                                    <td class="product-name">
                                        <select name="isOrderBox" class="form-control isOrderBox required">
                                            <option @if($cart->IS_BOX_ORDER==1) selected @endif value="1">Box</option>
                                            @foreach($uoms as $uom)
                                                @if($cart->PACK_TYPE_ID==$uom->LKP_DATAID)
                                                <option @if($cart->PACK_TYPE_ID==$uom->LKP_DATAID && $cart->IS_BOX_ORDER==0) selected @endif value="0">{{ $uom->LDATA_NAME }}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                    </td>
                                    <td class="product-name"><a href="#">${{ number_format($sellPrice, 2) }} </a></td>
                                    <td class="product-name"><a href="#"> {{ $cart->DISC_PCT ?? 0 }} </a> </td>
                                    <td class="product-price"><span class="amount">${{ number_format($unitPrice, 2) }}</span></td>
                                    <td class="product-quantity" style="width: 13%">
                                        <button type="button" class="btn btn-warning quantity-handler dec" @if($cart->QUANTITY<=1) disabled @endif data-status="dec"><i class="fa fa-minus-square"></i></button>
                                        <button type="button" class="btn btn-default quantity" data-id="{{ $cart->PRODUCT_ID }}" data-price="{{ $unitPrice }}">{{ $cart->QUANTITY }}</button>
                                        <button type="button" class="btn btn-success quantity-handler inc" @if($cart->QUANTITY>=100) disabled @endif data-status="inc"><i class="fa fa-plus-square"></i></button>
                                    </td>
                                    <td class="product-subtotal">$<span class="product-total-price">{{ number_format($totalPrice, 2) }}</span></td>
                                    <td class="product-trash"><a href="#"  class="product-remove" data-id="{{ $cart->PRODUCT_ID }}"><i class="icon-trash icons"></i></a></td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="row">
                        <div class="col-md-5 col-sm-12 col-xs-12">
                            <div class="buttons-cart--inner">
                                <div class="buttons-cart">
                                    <a href="{{ url('/') }}">Continue Shopping</a>
                                </div>
                            </div>
                            <div class="ht__coupon__code">
                                <span>enter your discount code</span>
                                <div class="coupon__box">
                                    <input type="text" placeholder="">
                                    <div class="ht__cp__btn">
                                        <a href="#">enter</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-7 col-sm-12 col-xs-12 smt-40 xmt-40">
                            <form id="orderForm" action="{{ url('carts/order-submit') }}" method="post">
                                @csrf
                                <div class="htc__cart__total">
                                    <h6>Order Information</h6>
                                    <div class="payment-style">
                                        <div class="col-md-6 payment-f6">
                                            <div class="col-md-12 shipping-form">
                                                <div class="form-group">
                                                    <label for="location">Location<span style="color: red"> *</span></label>
                                                    <input type="text" class="form-control orderPlace required" placeholder="Order Place" name="orderPlace" value="{{ $customer->ADDRESS }}">
                                                </div>
                                                <div class="form-group">
                                                    <label for="contact">Contact<span style="color: red"> *</span></label>
                                                    <input type="text" class="form-control contactNo required" placeholder="Mobile or Phone" name="contactNo" value="{{ $customer->CONTACT }}">
                                                </div>
                                                <div class="form-group">
                                                    <label for="deliveryDate">Delivery Date<span style="color: red"> *</span></label>
                                                    <input type="text" class="form-control deliveryDate date-picker required" placeholder="Delivery Date" name="deliveryDate" value="">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 payment-f6">
                                            <div class="shipping-form">
                                                <div class="cart__desk__list" style="margin: 0 !important;">
                                                    <ul class="cart__desc">
                                                        <li>Cart total</li>
                                                        <li>Tax</li>
                                                        <li>Shipping</li>
                                                    </ul>
                                                    <ul class="cart__price">
                                                        <li>$<span class="cart-total-price">{{ number_format($cartTotal, 2) }}</span></li>
                                                        <li>$0.00</li>
                                                        <li>0</li>
                                                    </ul>
                                                </div>
                                                <div class="cart__total">
                                                    <span>order total</span>
                                                    <span>$<span class="grant-total">{{ number_format($cartTotal, 2) }}</span></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <ul class="payment__btn" style="margin-top: 0">
                                        <li><button disabled type="button" class="btn orderSubmit" onclick="orderSubmit()" >Order Submit</button></li>
                                        {{--<li><button disabled="disabled" type="button" class="btn" >Payment</button></li>--}}
                                    </ul>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- cart-main-area end -->

    <!-- Start Banner Area -->
    <div class="htc__brand__area bg__cat--4">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="ht__brand__inner">
                        <ul class="brand__list owl-carousel clearfix">
                            <li><a href="#"><img src="{{ asset('public/assets/public/images/brand/1.png') }}" class="img-responsive" alt="brand images"></a></li>
                            <li><a href="#"><img src="{{ asset('public/assets/public/images/brand/2.png') }}" class="img-responsive" alt="brand images"></a></li>
                            <li><a href="#"><img src="{{ asset('public/assets/public/images/brand/3.png') }}" class="img-responsive" alt="brand images"></a></li>
                            <li><a href="#"><img src="{{ asset('public/assets/public/images/brand/4.png') }}" class="img-responsive" alt="brand images"></a></li>
                            <li><a href="#"><img src="{{ asset('public/assets/public/images/brand/5.png') }}" class="img-responsive" alt="brand images"></a></li>
                            <li><a href="#"><img src="{{ asset('public/assets/public/images/brand/5.png') }}" class="img-responsive" alt="brand images"></a></li>
                            <li><a href="#"><img src="{{ asset('public/assets/public/images/brand/1.png') }}" class="img-responsive" alt="brand images"></a></li>
                            <li><a href="#"><img src="{{ asset('public/assets/public/images/brand/2.png') }}" class="img-responsive" alt="brand images"></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Banner Area -->
    <script>
        $(document).ready(function () {
            checkEmptyCart();
        });
//        Submit Order Script
        const orderSubmit = () => {
            if(hasError()===true){
                return false;
            }
            swal.fire({
                title: 'Are you sure ?',
                text: "Please click confirm to Order Submit",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, confirm it!',
                cancelButtonText: 'No, cancel!',
                confirmButtonClass: 'btn btn-success',
                cancelButtonClass: 'btn btn-danger',
                buttonsStyling: true
            }).then(function (isConfirm) {
                if(isConfirm.value){
                    document.getElementById('orderForm').submit();
                } else{
                    swal.fire(
                        'Cancelled',
                        'Your imaginary file is safe :)',
                        'error'
                    )
                }
            })
        };

//        Event On Is Box Order
        $(document).on('change', '.isOrderBox', function () {
            var thisRow = $(this).closest('tr');
            var isBoxOrder = $(this).val();
            var productId = parseFloat(thisRow.find('.quantity').attr('data-id'));
            var quantity = parseFloat(thisRow.find('.quantity').text());
            var token = '{{ csrf_token() }}';

            $.ajax({
                type:'PUT',
                url: '{{ url('carts-box') }}/'+productId,
                data: { quantity: quantity, isBoxOrder: isBoxOrder, _token: token },
                success: function (data) {
//                    console.log(data);
                    location.reload();
                    $('.cart-notification').notify("Cart Updated", 'Success');
                }
            });
        });

//        Quantity Handler Script
        $(document).on('click', '.quantity-handler', function () {
            var thisRow = $(this).closest('tr');
            var quantityType = $(this).attr('data-status');
            var productId = parseFloat(thisRow.find('.quantity').attr('data-id'));
            var quantity = parseFloat(thisRow.find('.quantity').text());
            var price = parseFloat(thisRow.find('.quantity').attr('data-price'));
            var token = '{{ csrf_token() }}';

            if(quantity<=100){
                if(quantityType==='inc') {
                    quantity = quantity+1;
                } else{
                    if(quantity===1) { return false; }
                    quantity = quantity-1;
                }
                $.ajax({
                    type:'PUT',
                    url: '{{ url('carts') }}/'+productId,
                    data: { quantity: quantity, price: price, _token: token},
                    success: function (data) {
//                        console.log(data);
                        buttonDisableEnable(thisRow, quantity);
                        thisRow.find('.quantity').text(quantity);
                        thisRow.find('.product-total-price').text(numberFormat(quantity*price));
                        getUpdateCart();
                        updateCartTotal();
                        $('.cart-notification').notify("Cart Updated", 'Success');
                    }
                });
            }
        });

//        Cart Update in Total
        const updateCartTotal = () => {
            let thisRow = null;
            let price = null;
            let totalPrice = [];
            let cartTotal = null;
            $('.products-counter').each(function () {
                thisRow = $(this).closest('tr');
                price = parseFloat(removeNumberFormat(thisRow.find('.product-total-price').text()));
                if($.isNumeric(price)) totalPrice.push(price);
            });
            cartTotal = totalPrice.reduce((sum, x) => sum + x);
            $('.cart-total-price').text(numberFormat(cartTotal));
            $('.grant-total').text(numberFormat(cartTotal));
        };

//        Functions Use in cart
        function numberFormat(number){
            number = parseFloat(number).toFixed(2);
            return number.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        }
        function removeNumberFormat(number){
            return number.replace(/,/g, "");
        }

        const buttonDisableEnable = (thisRow, quantity) => {
            if(quantity>1){
                thisRow.find('.dec').prop('disabled', false);
            } else{
                thisRow.find('.dec').prop('disabled', true);
            }
        }

    </script>
@endsection