@extends('public.master')
<style>

    .table-content table th, .table-content table td {
        padding: 7px!important;
    }
    .table-content table td.product-trash i {
        color: #212121;
        display: inline-block;
        font-size: 24px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        width: 40px;
    }
    #scrollUp {
        padding-top: 8px;
    }
    .table-content table td.product-trash i:hover {
        color: red;
    }

    .form-group label{
        color: black;
        font-family: 'Poppins', sans-serif;
        font-size: 14px;
        font-weight: inherit;
        text-transform: uppercase;
    }
    .table>thead>tr>th, .table>tbody>tr>th, .table>tfoot>tr>th, .table>thead>tr>td, .table>tbody>tr>td, .table>tfoot>tr>td {
        padding: 8px;
        line-height: 1.42857143;
        vertical-align: top;
        border: 1px solid #ddd;
    }
    .profile-style{
        border: 1px solid gainsboro;
        margin: 15px 0 15px 0;
        background-color: #ececec;
    }
</style>
@section('content')
    <!-- cart-main-area start -->
    <div class="container">
        <div class="row profile-style">
            @include('public.layouts.customer.sidebar')
            <div class="col-md-10" style="padding: 15px">
                <div class="well">
                    <h2 class="text-center padding-md" style="margin-bottom: 10px;">Profile Update</h2>
                    <form action="{{ url('customer-profile-update/'.session('customerId')) }}" method="post" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="table-responsive">
                            <table border="1" rules="all" class="table">
                                <tr>
                                    <th>Username</th>
                                    <td class="td-row-width">
                                        <input type="text" class="form-control" name="USERNAME" value="{{ $customer->USERNAME }}" readonly>
                                    </td>
                                </tr>
                                <tr>
                                    <th>First Name</th>
                                    <td class="td-row-width">
                                        <input type="text" class="form-control" name="FIRST_NAME" value="{{ $customer->FIRST_NAME }}">
                                    </td>
                                </tr>
                                <tr>
                                    <th>Last Name</th>
                                    <td class="td-row-width">
                                        <input type="text" class="form-control" name="LAST_NAME" value="{{ $customer->LAST_NAME }}">
                                    </td>
                                </tr>
                                <tr>
                                    <th>Gender</th>
                                    <td class="td-row-width">
                                        <select name="GENDER" id="" class="form-control">
                                            <option value="M" @if($customer->GENDER==='M') selected @endif>Male</option>
                                            <option value="F" @if($customer->GENDER==='F') selected @endif>Female</option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Address</th>
                                    <td class="td-row-width">
                                        <input type="text" class="form-control" name="ADDRESS" value="{{ $customer->ADDRESS }}">
                                    </td>
                                </tr>
                                <tr>
                                    <th>Email <span style="color:#ff0000;">*</span></th>
                                    <td class="td-row-width">
                                        <input type="text" class="form-control" name="EMAIL" value="{{ $customer->EMAIL }}" readonly>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Contact <span style="color:#ff0000;">*</span></th>
                                    <td class="td-row-width">
                                        <input type="text" class="form-control" name="CONTACT" value="{{ $customer->CONTACT }}" required>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Photo </th>
                                    <td class="td-row-width">
                                        <input type="file" class="form-control" name="photo" id="customFile" >
                                    </td>
                                </tr>
                                <tr>
                                    <th></th>
                                    <td>
                                        <button type="submit" class="btn btn-default pull-right">Submit</button>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </form>
                </div>
            </div> <!-- col-md-9 -->
        </div> <!-- /.row -->
    </div>
    <!-- cart-main-area end -->

    <script>
        // image validation
        $('#customFile').bind('change', function () {
            var fileSize = this.files[0].size;
            var maxSize = 250000; // 250kb
            var validExtension = ['jpg','JPG','jpeg','JPEG','png','PNG',];
            var fileName = $('input[type=file]').val().split('\\').pop();

            if(fileSize>maxSize){
                alert('Warning! Maximum file size is 250');
                $('#customFile').val('');
            }
            if($.inArray($(this).val().split('.').pop().toLowerCase(),validExtension) == -1){
                alert("Only jpg, jpeg and png formats are allowed");
                $('#customFile').val('');
            }

        })
    </script>
@endsection