@extends('public.master')
<style>
    .table-content table th, .table-content table td {
        padding: 7px!important;
    }
    .table-content table td.product-trash i {
        color: #212121;
        display: inline-block;
        font-size: 24px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        width: 40px;
    }
    #scrollUp {
        padding-top: 8px;
    }
    .table-content table td.product-trash i:hover {
        color: red;
    }

    .form-group label{
        color: black;
        font-family: 'Poppins', sans-serif;
        font-size: 14px;
        font-weight: inherit;
        text-transform: uppercase;
    }
    .table>thead>tr>th, .table>tbody>tr>th, .table>tfoot>tr>th, .table>thead>tr>td, .table>tbody>tr>td, .table>tfoot>tr>td {
        padding: 8px;
        line-height: 1.42857143;
        vertical-align: top;
        border: 1px solid #ddd;
    }
    .profile-style{
        border: 1px solid gainsboro;
        margin: 15px 0 15px 0;
        background-color: #ececec;
    }
</style>
@section('content')
    <!-- cart-main-area start -->
    <div class="container">
        <div class="row profile-style">
            @include('public.layouts.customer.sidebar')
            <div class="col-md-10" style="padding: 15px">
                <div class="well">
                    <h2 class="text-center padding-md" style="margin-bottom: 10px;">Orders</h2>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                            <tr>
                                <th>Sl.</th>
                                <th>Order No</th>
                                <th>Order Date</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($orders as $key => $row)
                                <tr>
                                    <td>{{ ++$key }}</td>
                                    <td>#{{ $row->ORDERMST_ID }}</td>
                                    <td>{{ date('d M, Y', strtotime( $row->CREATED_AT))  }}</td>
                                    <td class="text-right">${{ number_format($row->totalAmount, 2) }}</td>
                                    <td class="text-right">
                                        @if($row->PAYMENT_FLG===1 && $row->ORDER_FLG===0)
                                            <button class="btn btn-warning btn-sm">Pending</button>
                                        @elseif($row->ORDER_FLG===1 && $row->DELIVERY_FLG===0)
                                            <button class="btn btn-primary btn-sm">Received</button>
                                        @elseif($row->DELIVERY_FLG===1 && $row->FINALIZE_FLG===0)
                                            <button class="btn btn-info btn-sm">Processing</button>
                                        @elseif($row->DELIVERY_FLG===1 && $row->FINALIZE_FLG===1)
                                            <button class="btn btn-success btn-sm">Delivered</button>
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        <a href="#" class="btn btn-info btn-sm" id="modalOpen"
                                           data-action="{{ url('customer-order-details/'.$row->ORDERMST_ID) }}"
                                           data-modal="modal-lg" data-title="View Order Details"
                                           data-toggle="modal"
                                           data-target="#openModal">
                                           <i class="fa fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div> <!--well-->
            </div>
        </div>
    </div>
    <!-- cart-main-area end -->

@endsection