@extends('public.master')
<style>
    .table-content table th, .table-content table td {
        padding: 7px!important;
    }
    .table-content table td.product-trash i {
        color: #212121;
        display: inline-block;
        font-size: 24px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        width: 40px;
    }
    #scrollUp {
        padding-top: 8px;
    }
    .table-content table td.product-trash i:hover {
        color: red;
    }

    .form-group label{
        color: black;
        font-family: 'Poppins', sans-serif;
        font-size: 14px;
        font-weight: inherit;
        text-transform: uppercase;
    }
    .table>thead>tr>th, .table>tbody>tr>th, .table>tfoot>tr>th, .table>thead>tr>td, .table>tbody>tr>td, .table>tfoot>tr>td {
        padding: 8px;
        line-height: 1.42857143;
        vertical-align: top;
        border: 1px solid #ddd;
    }
    .profile-style{
        border: 1px solid gainsboro;
        margin: 15px 0 15px 0;
        background-color: #ececec;
    }
</style>
@section('content')
    <!-- cart-main-area start -->
    <div class="container">
        <div class="row profile-style">
            @include('public.layouts.customer.sidebar')
            <div class="col-md-10" style="padding: 15px">
                <div class="well">
                    @if(!empty($customer->FIRST_NAME))
                        <h2 class="text-center padding-md" style="margin-bottom: 10px;">{{ $customer->FIRST_NAME }} {{ $customer->LAST_NAME }}</h2>
                    @else
                        <h2 class="text-center padding-md" style="margin-bottom: 10px;">Your Name</h2>
                    @endif
                    <div class="table-responsive">
                        <table border="1" rules="all" class="table">
                            <tr>
                                <th>Username</th>
                                <td>{{ $customer->USERNAME }}</td>
                            </tr>
                            <tr>
                                <th>First Name</th>
                                <td>{{ $customer->FIRST_NAME }}</td>
                            </tr>
                            <tr>
                                <th>Last Name</th>
                                <td>{{ $customer->LAST_NAME }}</td>
                            </tr>
                            <tr>
                                <th>Gender</th>
                                <td>
                                    @if ($customer->GENDER==='M')
                                        Male
                                    @elseif ($customer->GENDER==='F')
                                        Female
                                    @else
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Email</th>
                                <td>{{ $customer->EMAIL }}</td>
                            </tr>
                            <tr>
                                <th>Contact</th>
                                <td>{{ $customer->CONTACT }}</td>
                            </tr>
                            <tr>
                                <th>Address</th>
                                <td>{{ $customer->ADDRESS }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- cart-main-area end -->
@endsection