<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/admin', function () {
    return view('admin.layouts.dashboards.dashboards');
});

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');

//Access Control
Route::resource('users', 'UserController');
Route::resource('modules', 'ModuleController');
Route::resource('base-links', 'BaselinkController');
Route::resource('user-groups', 'UserGroupController');
Route::resource('role-assign', 'ModuleAssignController');
Route::post('role-assign/{id}', 'ModuleAssignController@handlePermission');

// lookup Setup
Route::resource('lookup-group-setup', 'LookupGroupController');
Route::resource('lookup-data-setup', 'LookupDataController');
Route::get('lookup-data-add/{group_id}', 'LookupDataController@addLookupData');

// basic setup
Route::resource('product-info','ProductInfoController');
Route::resource('product-policies','ProductPolicyController');
Route::resource('organizations','OrganizationController');
Route::resource('terms-conditions','TermConditionController');
Route::resource('celebrities-registration','CelebrityRegistrationController');
Route::get('delete_media_page/{userGroupId}','MemberRegistrationController@deleteMediaPage');
Route::resource('scores','CelebrityScoreController');
Route::get('show-product-in-website/{productId}','ProductInfoController@addProductToWebsite');
Route::resource('celebrity-order-info','CelOrderInfoController');
Route::post('search-celebrity-orders','CelOrderInfoController@searchCelebrityOrders');

// Profile
Route::resource('profiles', 'ProfileController');

// order
Route::resource('orders','OrderController');
Route::resource('orders-process','OrderProcessController');
Route::post('orders-process','OrderProcessController@OrderProcessWithCarry');
Route::resource('orders-deliver','OrderDeliveryController');
Route::resource('product-delivered','ProductDeliveredController');

// Product policy setup
Route::resource('product-policies', 'ProductPolicyController');

// Report Print
Route::resource('print-processed-orders', 'PrintProcessedOrderController');
Route::post('search-delivery-orders', 'PrintProcessedOrderController@searchDeliveryOrders');

// Item Stock
Route::resource('items-stock', 'ItemStockController');

// admin customers
Route::resource('admin-customers', 'AdminCustomerController');

// goods receive
Route::resource('goods-receive', 'GoodsReceiveController');
Route::post('verify-goods', 'GoodsReceiveController@verifyGoods');



/* Frontend Started*/
Route::get('celebrity-profiles/{id}/{product_id?}', 'CelebrityProfileController@show');


Route::get('/', 'WebsiteController@index');

// Product Details
Route::get('product-details/{productId}', 'ProductDetailsController@index');

// login and register
Route::post('customer-login', 'CustomerController@login');
Route::post('customer-register', 'CustomerController@store');
Route::get('customer-profile/{customerId}', 'CustomerController@show');
Route::get('customer-profile-edit/{customerId}', 'CustomerController@edit');
Route::put('customer-profile-update/{customerId}', 'CustomerController@update');
Route::get('customer-orders/{customerId}', 'CustomerController@customerOrders');
Route::get('customer-payment/{customerId}', 'CustomerController@customerPayment');
Route::post('customer-payment/{orderId}', 'CustomerController@customerPaymentStore');
Route::get('customer-order-details/{orderId}', 'CustomerController@customerOrderDetails');

//Cart
Route::resource('carts', 'CartController');
Route::put('carts-box/{productId}', 'CartController@updateIsBoxOrder');
Route::post('carts/order-submit', 'CartController@orderSubmit');

/* Frontend End*/

//report print
Route::get('search-delivery-orders-print/{carrierId}/{fromDate}/{toDate}', 'PrintProcessedOrderController@searchDeliveryOrdersPrint');

