<style>
    .profile-style{
        border: 1px solid gainsboro;
        margin: 15px 0 15px 0;
        background-color: #ececec;
    }
    .payment-parent{
        padding: 15px;
    }

    .pd-0{
        padding: 0 !important;
    }

    .payment-child{
        min-height: 350px !important;
        padding: 15px;
        border: 1px solid #E3E3E3;
    }

    .order-info{
        padding: 0;
        font-size: 16px;
        font-weight: bold;
        margin-bottom: 10px;
    }
    .terms-condition{
        color : red;
        font-size: 15px;
        line-height: 20px;
        text-align: justify;
        margin-bottom: 10px;
    }
    .checkbox-input{
        font-size: 14px;
    }
</style>
<?php $__env->startSection('content'); ?>
    <!-- cart-main-area start -->
    <div class="container">
        <div class="row profile-style">
            <?php echo $__env->make('public.layouts.customer.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="col-md-10" style="padding: 15px">
                <?php if(!empty($order)): ?>
                    <div class="col-md-12 well">
                        <h1 style="text-align: center">Payment Information</h1>
                        <h2 style="text-align: center">Order Number : <span style="color: red">#<?php echo e($order->ORDERMST_ID); ?></span></h2>
                    </div>
                    <div class="row">
                        <div class="col-lg-5 payment-parent">
                            <div class="col-md-12 payment-child">
                                <div class="col-md-12 well">
                                    <h3 class="text-center">Last Order Info</h3>
                                </div>
                                <div class="col-md-12 order-info">
                                    <div class="col-md-6 pd-0 text-left">Total amount</div>
                                    <div class="col-md-6 pd-0 text-right">$<?php echo e(number_format($order->TOTAL_PRICE, 2)); ?></div>
                                </div>
                                <div class="col-md-12 order-info">
                                    <div class="col-md-6 pd-0 text-left">Receiver Contact</div>
                                    <div class="col-md-6 pd-0 text-right"><?php echo e($order->CONTACT_NO); ?></div>
                                </div>
                                <div class="col-md-12 order-info">
                                    <div class="col-md-6 pd-0 text-left">Receiver Place</div>
                                    <div class="col-md-6 pd-0 text-right"><?php echo e($order->ORDER_PLACE); ?></div>
                                </div>
                                <div class="col-md-12 order-info">
                                    <div class="col-md-6 pd-0 text-left">Delivery Date</div>
                                    <div class="col-md-6 pd-0 text-right"><?php echo e(date('d-M-Y', strtotime($order->DELIVERY_DATE))); ?></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-7 col-md-7 col-sm-12 payment-parent">
                            <form id="paymentForm" method="post" action="<?php echo e(url('customer-payment/'.$order->ORDERMST_ID)); ?>" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>

                                <div class="col-md-12 payment-child">
                                    <div class="col-md-12 well">
                                        <h3 class="text-center">Payment</h3>
                                    </div>
                                    <!-- Terms and Condition -->
                                    <div class="col-md-12">
                                        <div class="cod_terms">
                                            <p class="terms-condition" style="margin-bottom: 5px;"><b>Cash on Delivery Terms & Condition</b>: </p>
                                            <?php $__currentLoopData = $codPaymentTermsConditions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $cod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p class="text-justify" style="font-size: 14px;"> <b> <?php echo e(++$i); ?>. </b><?php echo e($cod->TERMS_CONDTIONS_DESC); ?></p>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <div class="online_payment_terms hidden">
                                            <p class="terms-condition" style="margin-bottom: 5px;"><b> Online Payment Terms & Condition</b>: </p>
                                            <?php $__currentLoopData = $onlinePaymentTermsConditions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $cod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p class="text-justify" style="font-size: 14px;"> <b> <?php echo e(++$i); ?>. </b><?php echo e($cod->TERMS_CONDTIONS_DESC); ?></p>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                    <!-- /.Terms and Condition -->
                                    <div class="col-md-12 order-info" style="margin-top: 20px;">
                                        <div class="form-group">
                                            <div class="col-md-4 pd-0">
                                                <label for="location">Payment Type<span style="color: red"> *</span></label>
                                            </div>
                                            <div class="col-md-8 pd-0">
                                                <select name="paymentType" class="form-control paymentType required">
                                                    <option value="">Select One</option>
                                                    <?php $__currentLoopData = $paymentTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option <?php if($payment->ID==50): ?> selected <?php endif; ?> value="<?php echo e($payment->ID); ?>"><?php echo e($payment->NAME); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12 transact-form-input order-info hidden">
                                        <div class="form-group">
                                            <div class="col-md-4 pd-0">
                                                <label for="location">Transaction Doc<span style="color: red"> *</span></label>
                                            </div>
                                            <div class="col-md-8 pd-0">
                                                <input type="file" name="transaction_doc" disabled class="form-control transaction-doc required">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12 order-info">
                                        <div class="form-group">
                                            <div class="col-md-8 col-md-offset-4 checkbox-input">
                                                <input type="checkbox" name="isAgree" class="isAgree btn btn-md btn-primary" style="margin:0;height: 15px;width: 15px;"> <span> I Agree with yours Terms & Conditions</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12 order-info">
                                        <div class="form-group" style="margin-top: 5px">
                                            <div class="col-md-8 col-md-offset-4">
                                                <button type="button" onclick="paymentSubmit()" class="btn btn-md btn-primary">Submit</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <?php else: ?>
                    <div class="col-md-12 well">
                        <h1 style="text-align: center">Payment Information</h1>
                        <div class="row">
                            <div class="col-lg-12 payment-parent">
                                <div class="col-md-12 payment-child" style="border: 1px solid #efe9e9;padding-top: 120px">
                                    <h2 class="text-center text-danger">You have no Pending Orders</h2>
                                    <h3 class="text-center" style="font-size: 18px;margin-top: 15px;">To Purchase more Products, <a class="text-success" href="<?php echo e(url('/')); ?>" style="font-size: 20px">Click Here</a></h3>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
            </div>
        </div>
    </div>
    <!-- cart-main-area end -->
    <script>
        $(document).on('change', '.paymentType', function () {
            var paymentType = $(this).val();
            if(paymentType!==''){
                paymentType = parseInt(paymentType);
                if(paymentType===51){
                    $('.transaction-doc').prop('disabled', false);
                    $('.transact-form-input').removeClass('hidden');
                    $('.online_payment_terms').removeClass('hidden');
                    $('.cod_terms').addClass('hidden');
                } else{
                    $('.transaction-doc').prop('disabled', true);
                    $('.transact-form-input').addClass('hidden');
                    $('.online_payment_terms').addClass('hidden');
                    $('.cod_terms').removeClass('hidden');
                }
            }
        });

//        Payment Submitted
        const paymentSubmit = () => {
            let isAgree = $('.isAgree').is(':checked');
            swal.fire({
                title: 'Are you sure ?',
                text: "Please click confirm to Payment Submit",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, confirm it!',
                cancelButtonText: 'No, cancel!',
                confirmButtonClass: 'btn btn-success',
                cancelButtonClass: 'btn btn-danger',
                buttonsStyling: true
            }).then(function (isConfirm) {
                if(isConfirm.value){
                    if(isAgree===true){
                        document.getElementById('paymentForm').submit();
                        swal.fire(
                            'Success',
                            'Payment Submitted Successfully.',
                            'success'
                        )
                    } else{
                        swal.fire(
                            'Failed',
                            'Required Agreements with terms and conditions',
                            'error'
                        )
                    }
                } else{
                    swal.fire(
                        'Cancelled',
                        'Your imaginary file is safe :)',
                        'error'
                    )
                }
            })
        };

    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('public.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/salesforce/resources/views/public/layouts/customer/payment.blade.php ENDPATH**/ ?>