<?php $__env->startSection('content'); ?>
    <!-- Custom styles for this page -->
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <!-- DataTales Example -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Goods Received</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                            <thead>
                            <tr>
                                <th>Sl.</th>
                                <th>Product Name</th>
                                <th>Packet Type</th>
                                <th>Is Box</th>
                                <th>Qty.</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tfoot>
                            <tr>
                                <th>Sl.</th>
                                <th>Product Name</th>
                                <th>Packet Type</th>
                                <th>Is Box</th>
                                <th>Qty.</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </tfoot>
                            <tbody>
                            <?php $__currentLoopData = $goods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(++$key); ?></td>
                                    <td><?php echo e($row->PROD_NAME); ?></td>
                                    <td><?php echo e($row->LDATA_NAME); ?> </td>
                                    <td><input type="checkbox" <?php if($row->IS_BOX===1): ?> checked <?php endif; ?>></td>
                                    <td><?php echo e($row->QUANTITY); ?> </td>
                                    <td>
                                        <?php if($row->ACTIVE_FLG==1): ?>
                                            <button class="btn btn-primary btn-sm">Verified</button>
                                        <?php else: ?>
                                            <button class="btn btn-danger btn-sm verifyGoods" value="<?php echo e($row->GOODS_RCV_ID); ?>">Pending</button>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="#" class="btn btn-info btn-circle btn-sm" id="modalOpen" data-action="<?php echo e(url('goods-receive/'.$row->GOODS_RCV_ID.'/edit')); ?>" data-modal="modal-lg" data-title="Edit Product Receive"  data-toggle="modal" data-target="#openModal"><i class="fas fa-edit"></i></a>
                                        <a href="#" class="btn btn-danger btn-circle btn-sm clickForDelete row<?php echo e($row->GOODS_RCV_ID); ?>" data-token="<?php echo e(csrf_token()); ?>" data-action="<?php echo e(url('goods-receive/'.$row->GOODS_RCV_ID)); ?>" role="button"><i class="fas fa-trash"></i></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- ol-lg-12 col-md-12-->
    </div> <!-- /.row-->
    <?php echo $__env->make('admin.includes.deleteScript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
        $(document).on("click", ".verifyGoods", function (e) {
            e.preventDefault();
            var thisRow = $(this).closest('tr');
            var goodsId = thisRow.find('.verifyGoods').val();
            var actionUrl = "<?php echo e(url('verify-goods')); ?>";
            var token = "<?php echo e(csrf_token()); ?>";

            swal.fire({
                title:'Are you sure ?',
                type:'warning',
                text: 'Please click confirm to Verify',
                showCancelButton:true,
                confirmButtonText:'Yes, Confirm',
                cancelButtonText:'No, cancel',
                confirmButtonColor:'#3085d6',
                cancelButtonColor:'#d33',
                confirmButtonClass: 'btn-danger',
                cancelButtonClass:'btn-primary',
                buttonsStyling:true,
            }).then(function (isConfirm) {
            if (isConfirm.value){
                $.ajax({
                    type: 'POST',
                    data: {
                       _token: token, goodsId: goodsId
                    },
                    url: actionUrl,
                    success:function (data) {
                        location.reload();
                    }

                });
            }else{
                swal.fire(
                    'Canceled',
                    'Sorry! we could not verify',
                    'error'
                )
            }

            })
        })

    </script>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/salesforce/resources/views/admin/layouts/goodsReceive/index.blade.php ENDPATH**/ ?>