
<div class="table-responsive">
    <h4 class="text-center card-header">Orders to be delivered</h4>
    <table class="table table-bordered" width="100%" cellspacing="0">
        <thead>
        <tr>
            <th>Order</th>
            <th>Customer</th>
            <th>Product</th>
            <th>Photo</th>
            <th>Qty.</th>
            <th>Total</th>
            <th>Price</th>
            <th>Total</th>
            <th>Address</th>
            <th>Payment Type</th>
        </tr>
        </thead>
        <tfoot>
        <tr>
            <th>Order</th>
            <th>Customer</th>
            <th>Product</th>
            <th>Photo</th>
            <th>Qty.</th>
            <th>Total</th>
            <th>Price</th>
            <th>Total</th>
            <th>Address</th>
            <th>Payment Type</th>
        </tr>
        </tfoot>
        <tbody>
        <?php $__currentLoopData = $ordersToDeliver; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $childOrders = \Illuminate\Support\Facades\DB::table('sf_orderchd')
                                ->select('sf_orderchd.ORDERMST_ID','sf_orderchd.QUANTITY','sf_orderchd.PRICE','sf_product_info.PROD_NAME','sf_product_info.PRODUCT_IMG')
                                ->leftjoin('sf_product_info','sf_orderchd.PRODUCT_ID','=','sf_product_info.PRODUCT_ID')
                                ->where('sf_orderchd.ORDERMST_ID','=',$row->ORDERMST_ID)
                                ->get();
                $count = \Illuminate\Support\Facades\DB::table('sf_orderchd')
                                ->select(DB::raw('COUNT(ORDERMST_ID) AS rowSpan'), DB::raw('SUM(QUANTITY) AS totalQty') , DB::raw('SUM(PRICE) AS totalAmount'))
                                ->where('ORDERMST_ID','=',$row->ORDERMST_ID)
                                ->first();
            ?>
            <?php $__currentLoopData = $childOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2 => $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <?php if($key2==0): ?>
                        <td rowspan="<?php echo e($count->rowSpan); ?>">#<?php echo e($child->ORDERMST_ID); ?></td> <!-- order no -->
                        <td rowspan="<?php echo e($count->rowSpan); ?>"><?php echo e($row->USERNAME); ?></td>
                    <?php endif; ?>

                    <td><?php echo e($child->PROD_NAME); ?></td>
                    <td><img src="<?php echo e(asset('/uploads/products/'.$child->PRODUCT_IMG)); ?>" alt="Product Image" style="width: 40px;height: 40px;border: 1px solid lightgray;padding: 2px;"></td>
                    <td><?php echo e($child->QUANTITY); ?></td>

                    <?php if($key2==0): ?>
                        <td rowspan="<?php echo e($count->rowSpan); ?>"><?php echo e($count->totalQty); ?></td>
                    <?php endif; ?>

                    <td><?php echo e(number_format($child->PRICE, 2)); ?></td>

                    <?php if($key2==0): ?>
                        <td rowspan="<?php echo e($count->rowSpan); ?>"><?php echo e(number_format($count->totalAmount, 2)); ?></td>
                    <?php endif; ?>

                    <?php if($key2==0): ?>
                        <td rowspan="<?php echo e($count->rowSpan); ?>" style="width: 20%;"><?php echo e($row->ORDER_PLACE); ?></td>
                    <?php endif; ?>

                    <?php if($key2==0): ?>
                        <td rowspan="<?php echo e($count->rowSpan); ?>"><?php echo e($row->paymentType); ?></td>
                    <?php endif; ?>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div><?php /**PATH /var/www/html/salesforce/resources/views/admin/layouts/reportsPrint/processedOrders/orders.blade.php ENDPATH**/ ?>