<style>
    @media  all and (max-width: 600px){
        select {
            width: 100%; max-width: 100%;
        }
    }
</style>
<?php $__env->startSection('content'); ?>
    <!-- Custom styles for this page -->
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <!-- DataTales Example -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Orders Received</h6>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                            <thead>
                            <tr>
                                <th>Sl.</th>
                                <th>Process</th>
                                <th>Customer Name</th>
                                <th>Contact</th>
                                <th>Delivery Date</th>
                                <th>Payment Type</th>
                                <th>Total Amount</th>
                                <th>Delivery Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tfoot>
                            <tr>
                                <th>Sl.</th>
                                <th>Process</th>
                                <th>Customer Name</th>
                                <th>Contact</th>
                                <th>Delivery Date</th>
                                <th>Payment Type</th>
                                <th>Total Amount</th>
                                <th>Delivery Status</th>
                                <th>Action</th>
                            </tr>
                            </tfoot>
                            <tbody class="order-received">
                                <?php $__currentLoopData = $ordersProcess; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(++$key); ?></td>
                                    <th><input type="checkbox" class="isChecked" value="<?php echo e($row->ORDERMST_ID); ?>"></th>
                                    <td><?php echo e($row->USERNAME); ?></td>
                                    <td><?php echo e($row->CONTACT_NO); ?> </td>
                                    <td style="width: 14%"><?php if( $row->DELIVERY_DATE !=''?date('d-M-Y', strtotime($row->DELIVERY_DATE)):''): ?> <?php endif; ?></td>
                                    <td style="width: 15%"><button class="btn btn-primary btn-sm"><?php echo e($row->paymentType); ?></button></td>
                                    <td>$<?php echo e(number_format($row->totalAmount, 2)); ?> </td>
                                    <td><button class="btn btn-primary btn-sm">Pending</button></td>
                                    <td>
                                        <a href="#" class="btn btn-success btn-circle btn-sm" id="modalOpen" data-action="<?php echo e(url('orders-process/'.$row->ORDERMST_ID)); ?>" data-modal="modal-xl" data-title="View Order Process Details"  data-toggle="modal" data-target="#openModal"><i class="fas fa-eye"></i></a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- cary via -->
                <div class="form-row mt-3" style="margin-bottom:  100px !important;">
                    <div class="form-group ml-4">
                        <b>Choose Carrier</b>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <select class="form-control ml-4 carrier_id">
                                <option value=""> Select Carrier</option>
                                <?php $__currentLoopData = $organizations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($row->ORGANIZATION_ID); ?>"><?php echo e($row->ORGANIZATION_NAME); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group ml-4">
                            <button type="submit" class="btn btn-primary processOrders">Submit</button>
                        </div>
                    </div>
                </div>
                <!-- cary via -->
            </div>
        </div> <!-- ol-lg-12 col-md-12-->
    </div> <!-- /.row-->
<script>
    $(document).on('click', '.processOrders', function () {
        var orders_id = [];
        var carrier_id= $('.carrier_id').val();
        $('.order-received tr').each(function () {
            var thisRow = $(this).closest('tr');
            var isChecked = thisRow.find('.isChecked').is(':checked');
            if(isChecked===true){
                var orderId = thisRow.find('.isChecked').val();
                orders_id.push(orderId);
            }
        });

        if(orders_id.length>0 && carrier_id!==''){
            var token = '<?php echo e(csrf_token()); ?>';
            $.ajax({
                url: "<?php echo e(url('/orders-process')); ?>",
                type: "POST",
                data : { carrier_id : carrier_id, orders_id : orders_id.toString(), _token : token },
                success: function (data) {
                    ajaxAlertMessage(data);
                }
            });
        }
    });
</script>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/salesforce/resources/views/admin/layouts/orderProcess/process/index.blade.php ENDPATH**/ ?>